package gov.va.med.mhv.usermgmt.service.impl;

import java.util.List;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.usermgmt.bizobj.PatientExtractControlBO;
import gov.va.med.mhv.usermgmt.enumeration.ExtractType;
import gov.va.med.mhv.usermgmt.service.PatientExtractControlServiceResponse;
import gov.va.med.mhv.usermgmt.transfer.Patient;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.usermgmt.service.PHRFieldTestPatientService;

/**
 * Service implementation class for the PHRFieldTestPatient service
 * @see gov.va.med.mhv.usermgmt.service.PHRFieldTestPatientService
 */
public class PHRFieldTestPatientServiceImpl implements PHRFieldTestPatientService {

		private static final Log LOG = LogFactory.getLog(PHRFieldTestPatientServiceImpl.class);
	/**
	 * Execute the GetFieldTestPatient service
	 * @see gov.va.med.mhv.usermgmt.service.PHRFieldTestPatientService#GetFieldTestPatient()
	 */
	public PatientExtractControlServiceResponse getFieldTestPatient(ExtractType extractType, Patient patient) {

		PatientExtractControlServiceResponse response = new PatientExtractControlServiceResponse();
		response.setPatientExtractControl(null);
        List controlBOs = PatientExtractControlBO.getExtractEnabledByTypePatientID(extractType.getValue(),patient.getId());
   	   if ((controlBOs != null) && !controlBOs.isEmpty()) {
   		   LOG.info("Patient successfully matched fieldTest Table ");

			    response.setPatientExtractControl(
			    	((PatientExtractControlBO) controlBOs.get(0)).
			    	getPatientExtractControlValues());
	       }
   	   else{
   		   LOG.info("Patient is not field tester for extract type("+extractType.getName()+")");

   	   }

		return response;

	}

}